function Character(name, hp, mp, lv)
{
	this.name = name;					// Name
	this.hp = hp;							// Current HP
	this.maxhp = hp;						// Current maximum HP
	this.mp = mp;							// Current MP
	this.maxmp = mp;						// Current maximum MP
	this.lv = lv;								// Current Level
	this.exp = 0;							// Total experience
	this.next = 20;							// Experience needed for next level
	FigureLV(this, lv - 1);
	this.obtained = true;					// Found in game
	this.face = LoadImage("Face-" + name + ".png");
	this.strength = 5;						// Current strength
	this.speed = 5;						// Current speed
	this.magic = 5;						// Current magic
	this.stamina = 5;						// Current stamina
	this.sprite = LoadSpriteset(name + ".rss");
	this.situation = "Normal";			// Battle situation
	this.curFrame = 0;					// Current frame in battle animation
	this.time = 0;							// Battle time
	this.turn = false;						// Battle turn
	this.position = "Front";				// Position in battle
	this.idolix = new Array();			// Idolix equipped
	this.ability = new Array();			// Abilities equipped
	this.items = new Array();			// Items equipped
	this.items[0] = Items.Blank;		// Equipped weapon
	this.items[1] = Items.Blank;		// Equipped armlet
	this.items[2] = Items.Blank;		// Equipped helmet
	this.items[3] = Items.Blank;		// Equipped body armor
	this.items[4] = Items.Blank;		// Equipped accessory
	this.ailments = AilmentArray();	// Status ailments
	this.commands = new Array();	// Known commands
	this.proficient = new Array(5);
	this.proficient[0] = new Array();	// Proficient weapons
	this.proficient[1] = new Array();	// Proficient armlets
	this.proficient[2] = new Array();	// Proficient heads
	this.proficient[2][1] = "Hat";
	this.proficient[3] = new Array();	// Proficient bodies
	this.proficient[4] = new Array();	// Proficient accessories
	this.curMenu = undefined;			// Current menu in battle
	this.bMenu = new Menu(true);	// Main battle menu
	this.bMenu.addItem("Attack");
	this.bMenu.items[0] = Commands.TAttack;
	this.bMenu.addItem("White Mag");
	this.bMenu.items[1].enabled = false;
	this.bMenu.addItem("Heal");
	this.bMenu.items[2].enabled = false;
	this.bMenu.addItem("Item");
	this.bMenu.items[3].enabled = false;
	this.available = true;					// Available in battle
}

Character.prototype.clone = function()
{
	var tchar = new Character(this.name, this.hp, this.mp, this.lv);
	tchar.exp = this.exp;
	tchar.next = this.next;
	tchar.strength = this.strength;
	tchar.speed = this.speed;
	tchar.stamina = this.stamina;
	tchar.magic = this.magic;
	tchar.position = this.position;
	for (var i = 0; i < this.idolix.length; i ++)
	{
		tchar.idolix[i] = this.idolix[i].clone();
	}
	for (var i = 0; i < this.ability.length; i ++)
	{
		tchar.ability[i] = this.ability[i].clone();
	}
	tchar.items[0] = this.items[0].clone();
	tchar.items[1] = this.items[1].clone();
	tchar.items[2] = this.items[2].clone();
	tchar.items[3] = this.items[3].clone();
	tchar.ailments = this.ailments;
	tchar.commands = this.commands;
	tchar.bMenu = this.bMenu;
	return tchar;
}

Character.prototype.drawSprite = function()
{
	var x = this.x;
	var y = this.y;
	if (this.hp > this.maxhp * 0.25 && this.situation == "Normal")
	{
		font.drawText(x, y, "Normal", "center");
	}
	if (this.hp <= this.maxhp * 0.25 && this.hp > 0 && this.situation == "Normal")
	{
		font.drawText(x, y, "Weak", "center", Colors.Yellow);
	}
	if (this.hp == 0)
	{
		font.drawText(x, y, "Wounded", "center", Colors.Red);
	}
	if (this.ailments[0] == true)
	{
		font.drawText(x, y, "Poisoned", "center");
	}
	if (this.situation == "Preparing")
	{
		font.drawText(x, y, "Preparing", "center");
	}
	if (this.situation == "Attacking")
	{
		font.drawText(x, y, "Attacking!", "center");
	}
	if (this.situation == "MPreparing")
	{
		font.drawText(x, y, "Preparing to cast", "center");
	}
	if (this.situation == "Casting")
	{
		font.drawText(x, y, "Casting", "center");
	}
}

Character.prototype.getTarget = function()
{
	var targeterOpen = true;
	var battle = Game.curBattle;
	var tx = 0;
	var ty = 0;
	while (targeterOpen)
	{
		var aEnemies = AvailableEnemies();
		var aParty = AvailableCharacters();
		Game.curBattle.draw(false);
		if (Game.atb == "Active")
		{
			Game.curBattle.update();
		}
		window.drawWindow(36, 186, 94, 44, true, "TARGET");
		for (var i = 0; i < aEnemies.length; i ++)
		{
			font.drawText(36, 186 + i * 12, battle.enemy[aEnemies[i]].name);
		}
		window.drawWindow(148, 186, 60, 44, true, "PARTY");
		for (var i = 0; i < aParty.length; i ++)
		{
			font.drawText(148, 186 + i * 12, Game.party[aParty[i]].name);
		}
		DrawCursor(36 + tx * 112, 186 + ty * 12);
		if (tx == 0)
		{
			DrawCursor(battle.enemy[aEnemies[ty]].x, battle.enemy[aEnemies[ty]].y + battle.enemy[aEnemies[ty]].sprite.images[0].height / 2);
		}
		else
		{
			DrawCursor(Game.party[aParty[ty]].x, Game.party[aParty[ty]].y + Game.party[aParty[ty]].sprite.images[0].height / 2);
		}
		FlipScreen();
		if (LastPush())
		{
			if (IsKeyPressed(KEY_RIGHT))
			{
				KeyPressed();
				if (tx == 0)
				{
					tx = 1;
					ty = 0;
				}
				else
				{
					tx = 0;
					ty = 0;
				}
			}
			if (IsKeyPressed(KEY_LEFT))
			{
				KeyPressed();
				if (tx == 0)
				{
					tx = 1;
					ty = 0;
				}
				else
				{
					tx = 0;
					ty = 0;
				}
			}
			if (IsKeyPressed(KEY_DOWN))
			{
				KeyPressed();
				if (tx == 0)
				{
					if (ty < aEnemies.length - 1)
					{
						ty ++;
					}
					else
					{
						ty = 0;
					}
				}
				if (tx == 1)
				{
					if (ty < aParty.length - 1)
					{
						ty ++;
					}
					else
					{
						ty = 0;
					}
				}
			}
			if (IsKeyPressed(KEY_UP))
			{
				KeyPressed();
				if (tx == 0)
				{
					if (ty > 0)
					{
						ty --;
					}
					else
					{
						ty = aEnemies.length - 1;
					}
				}
				if (tx == 1)
				{
					if (ty > 0)
					{
						ty --;
					}
					else
					{
						ty = aParty.length - 1;
					}
				}
			}
			if (IsKeyPressed(Game.accept))
			{
				targeterOpen = false;
			}
		}
	}
	Game.curBattle.draw(false);
	if (tx == 0)
	{
		return Game.curBattle.enemy[aEnemies[ty]];
	}
	else
		return Game.party[aParty[ty]];
}

Character.prototype.die = function()
{

}

Character.prototype.levelUp = function()
{
	this.lv ++;
	this.maxhp += Math.floor(this.maxhp * 0.15);
	this.maxmp += Math.floor(this.maxmp * 0.15);
	this.strength += Math.floor(this.strength * 0.15);
	this.speed += Math.floor(this.speed * 0.15);
	this.stamina += Math.floor(this.stamina * 0.15);
	this.magic += Math.floor(this.magic * 0.15);
}

Character.prototype.giveExp = function(amount)
{
	for (var i = 0; i < amount; i ++)
	{
		this.next -= 1;
		this.exp += 1;
		if (this.next == 0)
		{
			this.levelUp();
			FigureLV(this, this.lv);
		}
	}
}

function FigureLV(character, amount)
{
	for (var i = 0; i < amount; i ++)
	{
		character.exp += character.next;
		character.next += (i + 2) * 10;
	}
}

function GetAttack(character)
{
	return character.strength + character.items[0].atk;
}

function GetDefense(character)
{
	return character.stamina + character.items[1].def + character.items[2].def + character.items[3].def;
}

function GetEvade(character)
{
	return character.speed;
}

function GetMDefense(character)
{
	return Math.floor((character.magic + character.stamina) / 2) + character.items[1].mdef + character.items[2].mdef + character.items[3].mdef;
}

function GetMEvade(character)
{
	return Math.floor((character.magic + character.speed) / 2);
}

Damizean = new Character("Damizean", 89, 18, 1);
Damizean.speed = 8;
Damizean.strength = 700;
Damizean.items[0] = Items.Weapons[0];
Damizean.proficient[0][0] = "Long Sword";

Annika = new Character("Annika", 1770, 134, 24);
Annika.items[0] = Items.Weapons[0];

/*
Dan = new Character("Richt", 10, 10, 15);
Dan.obtained = false;

Richt = new Character("Richt", 2235, 98, 5);
Richt.items[0] = Items.Weapons.WoodBlade;
*/